/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.lpar;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AuimlDataBeanAdapter;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskMessage;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PIIOPoolBean
extends AuimlDataBeanAdapter
implements TaskActionListener {
    public static final String ACTION_CREATE = "CREATE";
    public static final String ACTION_PROPERTIES = "PROPERTIES";
    private static final String BUNDLE_FILE = "PIHSCCommonBundle";
    private String ADD_BUTTON = "";
    private String REMOVE_BUTTON = "";
    private String IO_TABLE = "";
    private String IO_POOL_LIST = "";
    private static final String RANGE_ERROR = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "INVALID_POOL", null, new Object[]{"0", "65534"});
    private String m_sMaxIOPool;
    private String m_sIOPools;
    private ValueDescriptor[] m_vdIOPools;
    private String[] m_sLparPools;
    private ItemDescriptor[] m_idLparPools;
    private ArrayList m_lparIOPoolsList = new ArrayList();
    private ArrayList m_ioPoolsList = new ArrayList();
    private boolean m_isModified = false;
    private String m_actionType = "";
    private String[] m_systemPools = new String[0];

    public PIIOPoolBean() {
        this.m_actionType = ACTION_PROPERTIES;
        this._initComps();
    }

    public PIIOPoolBean(String string) {
        this.m_actionType = string;
        this._initComps();
    }

    public boolean isModified() {
        return this.m_isModified;
    }

    public String[] getLparIOPoolList() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.m_ioPoolsList.iterator();
        while (iterator.hasNext()) {
            hashSet.add((String)iterator.next());
        }
        iterator = this.m_lparIOPoolsList.iterator();
        while (iterator.hasNext()) {
            hashSet.add((String)iterator.next());
        }
        String[] stringArray = hashSet.toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            System.err.println(stringArray[i]);
        }
        return hashSet.toArray(new String[0]);
    }

    public void setLparIOPoolList(String[] stringArray) {
        if (stringArray != null) {
            Arrays.sort(stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_lparIOPoolsList.add(stringArray[i]);
            }
        }
    }

    public void setIOPoolList(String[] stringArray) {
        this.m_ioPoolsList = new ArrayList();
        if (stringArray != null) {
            Arrays.sort(stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                this.m_ioPoolsList.add(stringArray[i]);
            }
        }
    }

    public void setMaxIOPool(String string) throws IllegalUserDataException {
        this.m_sMaxIOPool = string;
    }

    public String getMaxIOPool() {
        return this.m_sMaxIOPool;
    }

    public ValueDescriptor[] getIOPoolsList() {
        String string = "*";
        this.m_vdIOPools = new ValueDescriptor[this.m_systemPools.length];
        for (int i = 0; i < this.m_systemPools.length; ++i) {
            this.m_vdIOPools[i] = new ValueDescriptor(this.m_systemPools[i] + string + i, this.m_systemPools[i]);
        }
        return this.m_vdIOPools;
    }

    public void setSystemIOPools(String[] stringArray) {
        if (stringArray != null) {
            this.m_systemPools = stringArray;
        }
    }

    public void setIOPools(String string) throws IllegalUserDataException {
        System.err.println("SetIOPools : " + string);
        this.m_sIOPools = string;
    }

    public String getIOPools() {
        return this.m_sIOPools;
    }

    public void setLparPoolsSelection(String[] stringArray) throws IllegalUserDataException {
        System.err.println("SetLparPoolsSelecttion ...items = " + stringArray.length);
        this.m_sLparPools = stringArray;
    }

    public String[] getLparPoolsSelection() {
        return this.m_sLparPools;
    }

    public void setLparPoolsList(ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.m_idLparPools = itemDescriptorArray;
    }

    public ItemDescriptor[] getLparPoolsList() {
        ItemDescriptor itemDescriptor = null;
        Iterator iterator = null;
        String string = null;
        HashMap<Integer, ItemDescriptor> hashMap = new HashMap<Integer, ItemDescriptor>();
        if (this.m_ioPoolsList.size() > 0) {
            iterator = this.m_ioPoolsList.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                itemDescriptor = new ItemDescriptor(string, string, "images/D_adapter.t.gif");
                itemDescriptor.setUserObject((Object)new Boolean(false));
                hashMap.put(new Integer(string), itemDescriptor);
            }
        }
        if (this.m_lparIOPoolsList.size() > 0) {
            iterator = this.m_lparIOPoolsList.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (this.m_ioPoolsList.contains(string)) continue;
                itemDescriptor = new ItemDescriptor(string, string);
                itemDescriptor.setUserObject((Object)new Boolean(true));
                hashMap.put(new Integer(string), itemDescriptor);
            }
        }
        if (hashMap.size() > 0) {
            Set set = hashMap.keySet();
            Object[] objectArray = set.toArray(new Object[0]);
            try {
                Arrays.sort(objectArray);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.m_idLparPools = new ItemDescriptor[objectArray.length];
            for (int i = 0; i < this.m_idLparPools.length; ++i) {
                this.m_idLparPools[i] = (ItemDescriptor)hashMap.get((Integer)objectArray[i]);
            }
        } else {
            this.m_idLparPools = new ItemDescriptor[0];
        }
        return this.m_idLparPools;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        this.m_sMaxIOPool = "0";
        this.m_sIOPools = "";
        this.m_vdIOPools = new ValueDescriptor[0];
        this.m_sLparPools = new String[0];
        this.m_idLparPools = new ItemDescriptor[0];
    }

    public void save() {
    }

    public void initRows() {
        if (this.m_idLparPools.length > 0) {
            for (int i = this.m_idLparPools.length - 1; i >= 0; --i) {
                System.err.println("m_idLparPools.length == " + this.m_idLparPools.length);
                System.err.println("removing row : " + i);
                this.m_utm.removeRow("LparIOPool.IOPoolTable", i);
            }
        }
    }

    public void initGUI() {
        if (Integer.parseInt(this.m_sMaxIOPool) <= this.m_idLparPools.length) {
            this.m_utm.setEnabled(this.ADD_BUTTON, false);
        }
    }

    public void actionPerformed(TaskActionEvent taskActionEvent) {
        if (taskActionEvent.getElementName().equals(this.ADD_BUTTON)) {
            if (this.m_idLparPools.length >= Integer.parseInt(this.m_sMaxIOPool)) {
                Object[] objectArray = new Object[]{this.m_sMaxIOPool};
                String string = HSCResourceBundleUtil.getMessage(BUNDLE_FILE, "MAX_NUM_IO_POOLS", null, objectArray);
                this._displayError(string);
                return;
            }
            String string = this.m_utm.getValue(this.IO_POOL_LIST).trim();
            int n = this.parsePoolId(string);
            if (n > 0) {
                return;
            }
            if (this.m_ioPoolsList.contains(string) || this.m_lparIOPoolsList.contains(string)) {
                Object[] objectArray = new Object[]{string};
                String string2 = HSCResourceBundleUtil.getMessage(BUNDLE_FILE, "DUPLICATE_POOL_ID", null, objectArray);
                this._displayError(string2);
                return;
            }
            this.m_lparIOPoolsList.add(string);
            this.m_isModified = true;
            this.m_utm.refreshElement(this.IO_TABLE);
        } else if (taskActionEvent.getElementName().equals(this.REMOVE_BUTTON)) {
            int[] nArray = this.m_utm.getSelectedRows(this.IO_TABLE);
            if (nArray != null && nArray.length > 0) {
                ItemDescriptor itemDescriptor = null;
                for (int i = 0; i < nArray.length; ++i) {
                    itemDescriptor = this.m_idLparPools[nArray[i]];
                    Object object = itemDescriptor.getUserObject();
                    if (object == null) continue;
                    if (!((Boolean)object).booleanValue()) {
                        Object[] objectArray = new Object[]{itemDescriptor.getTitle()};
                        String string = HSCResourceBundleUtil.getMessage(BUNDLE_FILE, "CANNOT_REMOVE_POOL_ID", null, objectArray);
                        this._displayError(string);
                        continue;
                    }
                    this.m_lparIOPoolsList.remove(itemDescriptor.getTitle());
                    this.m_isModified = true;
                    this.m_utm.refreshElement(this.IO_TABLE);
                }
            }
        } else if (taskActionEvent.getElementName().equals("OkButton")) {
            this.m_utm.dispose();
        } else if (taskActionEvent.getElementName().equals("CancelButton")) {
            this.m_isModified = false;
            this.m_utm.dispose();
        }
    }

    private void _initComps() {
        if (ACTION_PROPERTIES.equals(this.m_actionType)) {
            this.ADD_BUTTON = "Add";
            this.REMOVE_BUTTON = "Remove";
            this.IO_TABLE = "IOPoolTable";
            this.IO_POOL_LIST = "IOPools";
        } else {
            this.ADD_BUTTON = "LparIOPool.Add";
            this.REMOVE_BUTTON = "LparIOPool.Remove";
            this.IO_TABLE = "LparIOPool.IOPoolTable";
            this.IO_POOL_LIST = "LparIOPool.IOPools";
        }
    }

    private void _displayError(String string) {
        TaskMessage taskMessage = new TaskMessage(this.m_utm, string, 1);
        taskMessage.invoke();
    }

    private int parsePoolId(String string) {
        if (string.matches(".*[^0-9].*")) {
            this._displayError(RANGE_ERROR);
            this.m_utm.setValue(this.IO_POOL_LIST, "");
            return 1;
        }
        try {
            Integer n = new Integer(string);
            if (n < 0 || n > 65534) {
                this._displayError(RANGE_ERROR);
                this.m_utm.setValue(this.IO_POOL_LIST, "");
                return 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this._displayError(RANGE_ERROR);
            this.m_utm.setValue(this.IO_POOL_LIST, "");
            return 1;
        }
        return 0;
    }
}

